#include "stdafx.h"
#include "win_demo.h"
#include "DialogOSDParam.h"
#include "afxdialogex.h"
#include "sdks.h"
#include "common_struct.h"
#include "perser_json.h"
#include "pack_json.h"
#include "locale.h"
#include "trun_format.h"

extern int m_handle;
extern int m_chn_option;
jy_dev_osd_user_param_t stOSDUserParam = {0};
IMPLEMENT_DYNAMIC(CDialogOSDParam, CDialogEx)

CDialogOSDParam::CDialogOSDParam(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_WIN_OSD_PARAM, pParent)
{

}

CDialogOSDParam::~CDialogOSDParam()
{
}

BOOL CDialogOSDParam::OnInitOSDParam()
{
	char *p_result = NULL;
	CString strins;
	int nRet = sdks_get_osd_param(m_handle, m_chn_option, &p_result);
	if (!nRet)
	{
		json_perser_osd_param(p_result, &stOSDUserParam);
	}
	m_osd_param_time_format.InsertString(0, TEXT("YYYY-MM-DD hh:mm:ss"));
	m_osd_param_time_format.InsertString(1, TEXT("hh:mm:ss MM-DD-YYYY"));
	m_osd_param_time_format.InsertString(2, TEXT("MM-DD-YYYY hh:mm:ss"));
	m_osd_param_time_format.InsertString(3, TEXT("hh:mm:ss MM-DD-YYYY"));
	m_osd_param_time_format.InsertString(4, TEXT("DD-MM-YYYY hh:mm:ss"));
	m_osd_param_time_format.InsertString(5, TEXT("hh:mm:ss DD-MM-YYYY"));
	m_osd_param_time_format.SetCurSel(0);
	m_osd_param_font_alpha.InsertString(0, TEXT("Transparent"));
	m_osd_param_font_alpha.InsertString(1, TEXT("Micro transparent"));
	m_osd_param_font_alpha.InsertString(2, TEXT("Translucence"));
	m_osd_param_font_alpha.InsertString(3, TEXT("Opaque"));
	m_osd_param_time_format.SetCurSel(3);
	m_osd_param_area_id.InsertString(0, TEXT("1"));
	m_osd_param_area_id.InsertString(1, TEXT("2"));
	m_osd_param_area_id.InsertString(2, TEXT("3"));
	m_osd_param_area_id.InsertString(3, TEXT("4"));
	m_osd_param_area_id.InsertString(4, TEXT("5"));
	m_osd_param_area_id.InsertString(5, TEXT("6"));
	m_osd_param_area_id.InsertString(6, TEXT("7"));
	m_osd_param_area_id.InsertString(7, TEXT("8"));
	m_osd_param_area_id.SetCurSel(0);
	m_osd_param_align_mode.InsertString(0, TEXT("Align left"));
	m_osd_param_align_mode.InsertString(1, TEXT("Align right"));
	m_osd_param_align_mode.SetCurSel(0);
	m_osd_param_type.InsertString(0, TEXT("Device name"));
	m_osd_param_type.InsertString(1, TEXT("Camera ID"));
	m_osd_param_type.InsertString(2, TEXT("Camera name"));
	m_osd_param_type.InsertString(3, TEXT("Time"));
	m_osd_param_type.InsertString(4, TEXT("Info"));
	m_osd_param_type.InsertString(5, TEXT("PTZ position"));
	m_osd_param_type.InsertString(6, TEXT("PTZ behavior"));
	m_osd_param_type.InsertString(7, TEXT("Temperature"));
	m_osd_param_type.SetCurSel(0);
	m_osd_param_font_height.InsertString(0, TEXT("8 pounds"));
	m_osd_param_font_height.InsertString(1, TEXT("16 pounds"));
	m_osd_param_font_height.InsertString(2, TEXT("24 pounds"));
	m_osd_param_font_height.InsertString(3, TEXT("32 pounds"));
	m_osd_param_font_height.SetCurSel(2);
	m_osd_param_time_format.SetCurSel(stOSDUserParam.osd_global_param.time_format_id - 1);
	m_osd_param_font_alpha.SetCurSel(stOSDUserParam.osd_global_param.osd_font_alpha >> 4);
	strins.Format(_T("%d"), stOSDUserParam.osd_global_param.channel_id);
	m_osd_param_chn_id.SetWindowTextA(strins);
	strins.Format(_T("%d"), stOSDUserParam.osd_global_param.font_color.n_r);
	m_osd_param_font_color_r.SetWindowTextA(strins);
	strins.Format(_T("%d"), stOSDUserParam.osd_global_param.font_color.n_g);
	m_osd_param_font_color_g.SetWindowTextA(strins);
	strins.Format(_T("%d"), stOSDUserParam.osd_global_param.font_color.n_b);
	m_osd_param_font_color_b.SetWindowTextA(strins);
	strins.Format(_T("%d"), stOSDUserParam.osd_global_param.font_inverse_color.n_r);
	m_osd_param_inverse_color_r.SetWindowTextA(strins);
	strins.Format(_T("%d"), stOSDUserParam.osd_global_param.font_inverse_color.n_g);
	m_osd_param_inverse_color_g.SetWindowTextA(strins);
	strins.Format(_T("%d"), stOSDUserParam.osd_global_param.font_inverse_color.n_b);
	m_osd_param_inverse_color_b.SetWindowTextA(strins);
	((CButton*)GetDlgItem(IDC_CHECK_TWELVE_HOURS))->SetCheck(0);
	if (stOSDUserParam.osd_global_param.twelve_hours_flag)
	{
		((CButton*)GetDlgItem(IDC_CHECK_TWELVE_HOURS))->SetCheck(1);
	}
	((CButton*)GetDlgItem(IDC_CHECK_WEEK))->SetCheck(0);
	if (stOSDUserParam.osd_global_param.week_flag)
	{
		((CButton*)GetDlgItem(IDC_CHECK_WEEK))->SetCheck(1);
	}
	((CButton*)GetDlgItem(IDC_CHECK_INVERSE_FLAG))->SetCheck(0);
	if (stOSDUserParam.osd_global_param.inverse_flag)
	{
		((CButton*)GetDlgItem(IDC_CHECK_INVERSE_FLAG))->SetCheck(1);
	}
	OnCbnSelchangeComAreaId();
	return TRUE;
}

void CDialogOSDParam::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	//DDX_Control(pDX, IDC_EDIT_V_BPS, m_stream_param_bps);
	//DDX_Control(pDX, IDC_COMBO_V_QUALITY, m_stream_param_quality);
	DDX_Control(pDX, IDC_COM_FONT_ALPHA, m_osd_param_font_alpha);
	DDX_Control(pDX, IDC_EDIT_CHANNEL_ID, m_osd_param_chn_id);
	DDX_Control(pDX, IDC_EDIT_FONT_R, m_osd_param_font_color_r);
	DDX_Control(pDX, IDC_EDIT_FONT_G, m_osd_param_font_color_g);
	DDX_Control(pDX, IDC_EDIT_FONT_B, m_osd_param_font_color_b);
	DDX_Control(pDX, IDC_EDIT_INVERSE_R, m_osd_param_inverse_color_r);
	DDX_Control(pDX, IDC_EDIT_INVERSE_G, m_osd_param_inverse_color_g);
	DDX_Control(pDX, IDC_EDIT_INVERSE_B, m_osd_param_inverse_color_b);
	DDX_Control(pDX, IDC_EDIT_AREA_TOP_X, m_osd_param_area_top_x);
	DDX_Control(pDX, IDC_EDIT_AREA_TOP_Y, m_osd_param_area_top_y);
	DDX_Control(pDX, IDC_EDIT_AREA_WIDTH, m_osd_param_area_width);
	DDX_Control(pDX, IDC_EDIT_AREA_HEIGHT, m_osd_param_area_height);
	DDX_Control(pDX, IDC_EDIT_ARROW, m_osd_param_arrow_id);
	DDX_Control(pDX, IDC_EDIT_INFO, m_osd_param_osd_info);
	DDX_Control(pDX, IDC_COM_FONT_HEIGHT, m_osd_param_font_height);
	DDX_Control(pDX, IDC_COM_TIME_FORMAT, m_osd_param_time_format);
	DDX_Control(pDX, IDC_COM_AREA_ID, m_osd_param_area_id);
	DDX_Control(pDX, IDC_COM_ALIGN_MODE, m_osd_param_align_mode);
	DDX_Control(pDX, IDC_COM_TYPE, m_osd_param_type);
}


BEGIN_MESSAGE_MAP(CDialogOSDParam, CDialogEx)
	ON_CBN_SELCHANGE(IDC_COM_AREA_ID, &CDialogOSDParam::OnCbnSelchangeComAreaId)
	ON_BN_CLICKED(IDOK, &CDialogOSDParam::OnBnClickedOk)
END_MESSAGE_MAP()

void CDialogOSDParam::OnCbnSelchangeComAreaId()
{
	char osd_info[128] = { 0 };
	CString str_area_id;
	CString strins;
	int chn_index = m_osd_param_area_id.GetCurSel();
	m_osd_param_area_id.GetLBText(chn_index, str_area_id);
	int area_id = _ttoi(str_area_id);
	for (int i = 0; i < stOSDUserParam.canvas_proper_num; ++i)
	{
		if (area_id == stOSDUserParam.canvas_proper_list[i].area_id)
		{
			strins.Format(_T("%f"), stOSDUserParam.canvas_proper_list[i].area_param.top_x);
			m_osd_param_area_top_x.SetWindowTextA(strins);
			strins.Format(_T("%f"), stOSDUserParam.canvas_proper_list[i].area_param.top_y);
			m_osd_param_area_top_y.SetWindowTextA(strins);
			strins.Format(_T("%f"), stOSDUserParam.canvas_proper_list[i].area_param.width);
			m_osd_param_area_width.SetWindowTextA(strins);
			strins.Format(_T("%f"), stOSDUserParam.canvas_proper_list[i].area_param.height);
			m_osd_param_area_height.SetWindowTextA(strins);
			if (24 == stOSDUserParam.canvas_proper_list[i].front_height)
			{
				m_osd_param_font_height.SetCurSel(0);
			}
			else if (16 == stOSDUserParam.canvas_proper_list[i].front_height || 48 == stOSDUserParam.canvas_proper_list[i].front_height)
			{
				m_osd_param_font_height.SetCurSel(1);
			}
			else if (32 == stOSDUserParam.canvas_proper_list[i].front_height)
			{
				m_osd_param_font_height.SetCurSel(2);
			}
			else if (64 == stOSDUserParam.canvas_proper_list[i].front_height || 96 == stOSDUserParam.canvas_proper_list[i].front_height)
			{
				m_osd_param_font_height.SetCurSel(3);
			}
			else
				m_osd_param_font_height.SetCurSel(2);
			m_osd_param_align_mode.SetCurSel(stOSDUserParam.canvas_proper_list[i].align_mode);
			m_osd_param_type.SetCurSel(stOSDUserParam.canvas_proper_list[i].osd_info[0].type - 1);
			((CButton*)GetDlgItem(IDC_CHECK_USE))->SetCheck(0);
			if (stOSDUserParam.canvas_proper_list[i].osd_info[0].enable_flag)
			{
				((CButton*)GetDlgItem(IDC_CHECK_USE))->SetCheck(1);
			}
			strins.Format(_T("%d"), stOSDUserParam.canvas_proper_list[i].osd_info[0].arrow_id);
			m_osd_param_arrow_id.SetWindowTextA(strins);
			Utf8ToAnsi(stOSDUserParam.canvas_proper_list[i].osd_info[0].info, osd_info, 128);
			m_osd_param_osd_info.SetWindowTextA(osd_info);
			int area_type = stOSDUserParam.canvas_proper_list[i].osd_info[0].type;
			if (4 == area_type || 6 == area_type || 7 == area_type || 8 == area_type)
			{
				m_osd_param_osd_info.EnableWindow(FALSE);
			}
			else
			{
				m_osd_param_osd_info.EnableWindow(TRUE);
			}
		}
	}
}

void CDialogOSDParam::OnBnClickedOk()
{
	CDialogEx::OnOK();
	int tmp_index;
	CString str_tmp;
	char *p_param = NULL;
	char osd_info[128] = { 0 };
	tmp_index = m_osd_param_time_format.GetCurSel();
	stOSDUserParam.osd_global_param.time_format_id = tmp_index + 1;
	tmp_index = m_osd_param_font_alpha.GetCurSel();
	stOSDUserParam.osd_global_param.osd_font_alpha = (tmp_index << 4);
	m_osd_param_chn_id.GetWindowText(str_tmp);
	stOSDUserParam.osd_global_param.channel_id = _ttoi(str_tmp);
	m_osd_param_font_color_r.GetWindowText(str_tmp);
	if ((_ttoi(str_tmp) < 0) || (_ttoi(str_tmp) > 255))
	{
		MessageBoxA("Set font color error!");
		return;
	}
	stOSDUserParam.osd_global_param.font_color.n_r = _ttoi(str_tmp);
	m_osd_param_font_color_g.GetWindowText(str_tmp);
	if ((_ttoi(str_tmp) < 0) || (_ttoi(str_tmp) > 255))
	{
		MessageBoxA("Set font color error!");
		return;
	}
	stOSDUserParam.osd_global_param.font_color.n_g = _ttoi(str_tmp);
	m_osd_param_font_color_b.GetWindowText(str_tmp);
	if ((_ttoi(str_tmp) < 0) || (_ttoi(str_tmp) > 255))
	{
		MessageBoxA("Set font color error!");
		return;
	}
	stOSDUserParam.osd_global_param.font_color.n_b = _ttoi(str_tmp);
	m_osd_param_inverse_color_r.GetWindowText(str_tmp);
	if ((_ttoi(str_tmp) < 0) || (_ttoi(str_tmp) > 255))
	{
		MessageBoxA("Set inverse color error!");
		return;
	}
	stOSDUserParam.osd_global_param.font_inverse_color.n_r = _ttoi(str_tmp);
	m_osd_param_inverse_color_g.GetWindowText(str_tmp);
	if ((_ttoi(str_tmp) < 0) || (_ttoi(str_tmp) > 255))
	{
		MessageBoxA("Set inverse color error!");
		return;
	}
	stOSDUserParam.osd_global_param.font_inverse_color.n_g = _ttoi(str_tmp);
	m_osd_param_inverse_color_b.GetWindowText(str_tmp);
	if ((_ttoi(str_tmp) < 0) || (_ttoi(str_tmp) > 255))
	{
		MessageBoxA("Set inverse color error!");
		return;
	}
	stOSDUserParam.osd_global_param.font_inverse_color.n_b = _ttoi(str_tmp);
	stOSDUserParam.osd_global_param.twelve_hours_flag = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_TWELVE_HOURS))->GetCheck() == TRUE)
	{
		stOSDUserParam.osd_global_param.twelve_hours_flag = 1;
	}
	stOSDUserParam.osd_global_param.week_flag = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_WEEK))->GetCheck() == TRUE)
	{
		stOSDUserParam.osd_global_param.week_flag = 1;
	}
	stOSDUserParam.osd_global_param.inverse_flag = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_INVERSE_FLAG))->GetCheck() == TRUE)
	{
		stOSDUserParam.osd_global_param.inverse_flag = 1;
	}
	tmp_index = m_osd_param_area_id.GetCurSel() + 1;
	for (int i = 0; i < stOSDUserParam.canvas_proper_num; ++i)
	{
		if (tmp_index == stOSDUserParam.canvas_proper_list[i].area_id)
		{
			int index_tmp = m_osd_param_font_height.GetCurSel();
			if (0 == index_tmp)
			{
				stOSDUserParam.canvas_proper_list[i].front_width = 24;
				stOSDUserParam.canvas_proper_list[i].front_height = 24;
			}
			else if (1 == index_tmp)
			{
				stOSDUserParam.canvas_proper_list[i].front_width = 16;
				stOSDUserParam.canvas_proper_list[i].front_height = 16;
			}
			else if (2 == index_tmp)
			{
				stOSDUserParam.canvas_proper_list[i].front_width = 32;
				stOSDUserParam.canvas_proper_list[i].front_height = 32;
			}
			else if (3 == index_tmp)
			{
				stOSDUserParam.canvas_proper_list[i].front_width = 64;
				stOSDUserParam.canvas_proper_list[i].front_height = 64;
			}
			else
			{
				stOSDUserParam.canvas_proper_list[i].front_width = 32;
				stOSDUserParam.canvas_proper_list[i].front_height = 32;
			}
			index_tmp = m_osd_param_align_mode.GetCurSel();
			stOSDUserParam.canvas_proper_list[i].align_mode = index_tmp;
			m_osd_param_area_top_x.GetWindowText(str_tmp);
			if ((_ttof(str_tmp) < 0) || (_ttof(str_tmp) > 100))
			{
				MessageBoxA("Set area param error!");
				return;
			}
			stOSDUserParam.canvas_proper_list[i].area_param.top_x = _ttof(str_tmp);
			m_osd_param_area_top_y.GetWindowText(str_tmp);
			if ((_ttof(str_tmp) < 0) || (_ttof(str_tmp) > 100))
			{
				MessageBoxA("Set area param error!");
				return;
			}
			stOSDUserParam.canvas_proper_list[i].area_param.top_y = _ttof(str_tmp);
			m_osd_param_area_width.GetWindowText(str_tmp);
			if ((_ttof(str_tmp) < 0) || (_ttof(str_tmp) > 100))
			{
				MessageBoxA("Set area param error!");
				return;
			}
			stOSDUserParam.canvas_proper_list[i].area_param.width = _ttof(str_tmp);
			m_osd_param_area_height.GetWindowText(str_tmp);
			if ((_ttof(str_tmp) < 0) || (_ttof(str_tmp) > 100))
			{
				MessageBoxA("Set area param error!");
				return;
			}
			stOSDUserParam.canvas_proper_list[i].area_param.height = _ttof(str_tmp);
			stOSDUserParam.canvas_proper_list[i].osd_info[0].enable_flag = 0;
			if (((CButton*)GetDlgItem(IDC_CHECK_USE))->GetCheck() == TRUE)
			{
				stOSDUserParam.canvas_proper_list[i].osd_info[0].enable_flag = 1;
			}
			index_tmp = m_osd_param_type.GetCurSel();
			stOSDUserParam.canvas_proper_list[i].osd_info[0].type = index_tmp + 1;
			/*CEdit m_osd_param_osd_info;*/
			if ((2 == tmp_index) || (3 == tmp_index) || (4 == tmp_index) || (5 == tmp_index))
			{
				m_osd_param_arrow_id.GetWindowText(str_tmp);
				stOSDUserParam.canvas_proper_list[i].osd_info[0].arrow_id = _ttoi(str_tmp);
				m_osd_param_osd_info.GetWindowText(str_tmp);
				int nlarge = str_tmp.GetLength();
				if ((str_tmp.GetLength() < 0) || (str_tmp.GetLength() > 64))
				{
					MessageBoxA("OSD info is too long!");
					return;
				}
				AnsiToUtf8(str_tmp, osd_info, 128);
				strcpy(stOSDUserParam.canvas_proper_list[i].osd_info[0].info, osd_info);
				stOSDUserParam.canvas_proper_list[i].osd_info_list_num = 1;
			}
			UINT i = MessageBoxA(_T("Are you sure you want to set the OSD?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
			if (IDYES == i)
			{
				pack_json_osd_param(&stOSDUserParam, &p_param);
				int nRet = sdks_set_osd_param(m_handle, stOSDUserParam.camera_id, p_param);
				if (nRet) {
					MessageBoxA("Failed to set osd fail!");
					return;
				}
			}
		}
	}
}
